<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupérer et sécuriser les données du formulaire
    $name = htmlspecialchars(trim($_POST['name']));
    $phone = htmlspecialchars(trim($_POST['phone']));
    $email = htmlspecialchars(trim($_POST['email']));
    $message = htmlspecialchars(trim($_POST['message']));

    // Valider l'adresse email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        header("Location: commande.php?status=error");
        exit;
    }

    // Configurer l'e-mail
    $to = "angelxp@outlook.fr"; // Votre adresse e-mail ici
    $subject = "Nouveau message de contact de $name";
    $email_body = "Vous avez reçu un nouveau message via le formulaire de contact.\n\n";
    $email_body .= "Nom: $name\n";
    $email_body .= "Téléphone: $phone\n";
    $email_body .= "Email: $email\n";
    $email_body .= "Message:\n$message\n";

    $headers = "From: $name <$email>\r\n";
    $headers .= "Reply-To: $email\r\n";

    // Envoyer l'e-mail
    if (mail($to, $subject, $email_body, $headers)) {
        // Rediriger vers la page de contact avec un message de succès
        header("Location: commande.php?status=success");
    } else {
        // Rediriger vers la page de contact avec un message d'erreur
        header("Location: commande.php?status=error");
    }
} else {
    // Si la requête n'est pas POST, rediriger vers le formulaire
    header("Location: commande.php");
}
exit;
?>
